
import glob
from os import getcwd as pwd
from os.path import join, splitext, basename, dirname
from t3dn_bip_converter import convert

# source .venv/bin/activate
# pip install --upgrade pip
# pip install t3dn-bip
# pip install t3dn-bip-converter
# Uso desde fuera: (la gente usa subprocess para esto, pero no es necesario) "python -m t3dn_bip_converter source_file.png destination_file.bip"
# La libreria de t3dn_bip se descarga de https://github.com/bonjorno7/3dn-bip/releases (para poder usar el import de su preview y no el de blender)

""" 
    ** Para Uso interno de RBDLabStudio **
    source .venv/bin/activate
    cd libs/materials/thumbnails ; python3 converter.py
"""

current_dir = pwd()
full_path = join(current_dir, '*.png')
absolute_path_pngs = glob.glob(full_path)

# Convierto todos mis .png del mismo directorio a .bip:
for png_file in absolute_path_pngs:
    file_name = splitext(basename(png_file))[0]
    new_filename = join(dirname(png_file), f"{file_name}.bip")
    convert.convert_file(png_file, new_filename)